<fieldset @class(['wizard-fieldset', 'show'=> $step == 3]) x-data="{proceed: false}">
    <h5>Verify your identity</h5>
    <p>We're required by law to collect your Social Security Number / TIN.</p>
    <div x-show="!proceed">
        <div class="container">

            <div class="row mb-3">
                <div class="col-md-2 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewbox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="feather feather-lock text-primary">
                        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                    </svg>
                </div>
                <div class="col-md-10">
                    <h6>Security in mind</h6>
                    We use your SSN or TIN to help keep your account safe and secure.
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-md-2 mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewbox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="feather feather-credit-card text-primary">
                        <rect x="1" y="4" width="22" height="16" rx="2" ry="2"></rect>
                        <line x1="1" y1="10" x2="23" y2="10"></line>
                    </svg>
                </div>
                <div class="col-md-10">
                    <h6>Only for what you need</h6>
                    Occasionally we'll need to provide you with tax documents, which require
                    your SSN.
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-md-2 mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewbox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="feather feather-edit text-primary">
                        <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7">
                        </path>
                        <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z">
                        </path>
                    </svg>
                </div>
                <div class="col-md-10">
                    <h6>No credit score impact</h6>
                    Applying for {{ settings()->site_name }} Account will never impact your credit score
                </div>
            </div>

        </div>
    </div>

    <div x-show="proceed==true" x-cloak>
        <div class="form-group">
            <x-widgets.register-input name="ssn" label="Identity Number*" />
        </div>

        <div class="form-group mt-5">
            <x-widgets.register-input name="ssn_confirmation" label="Confirm Identity Number*" />
        </div>
    </div>

    <div class="form-group clearfix">
        <a href="javascript:;" class="form-wizard-previous-btn float-right" @click.prevent="proceed=true" x-show="proceed==false" >Proceed</a>
        
        <x-widgets.action-button button-text="Next" :next="false" x-show="!proceed" />
        <x-widgets.action-button button-text="Next" :next="true" x-show="proceed" x-cloak />
    </div>
</fieldset>