<x-layouts.auth title="Forgot Password">
  <x-slot:subtitle>
    Forgot Password
  </x-slot:subtitle>
  @if (session('message'))
  <div class="alert alert-success" role="alert">
    {{ __('A fresh verification link has been sent to your email address.') }}
  </div>
  @endif
  @if (session('status'))
  <div class="alert alert-success" role="alert">
    {{ session('status') }}
  </div>
  @endif
  <form method="post" action="{{ route('password.email') }}">
    @csrf
    <div class="form-group">
      <div class="form-label-group">
        <label class="form-label" for="default-01">Enter Your Email Address</label>
      </div>
      <input type="email" name="email" placeholder="username@email.com"
        class="@error('email') is-invalid @enderror form-control form-control-lg" required=""
        value="{{ old('email') }}">
      @error('email')
      <span class="invalid-feedback" role="alert">
        <strong>{{ $message }}</strong>
      </span>
      @enderror
    </div>
    <div class="form-group">

      <button class="btn btn-lg btn-primary btn-block" name="reset" type="submit">Reset
        Password</button>
      <a href="{{ route('login') }}" class="btn btn-lg btn-primary btn-block">Go back to
        login</a>

    </div>
  </form>
</x-layouts.auth>