@props(['title', 'user' => auth()->user() ])
<!DOCTYPE html>
<html class="no-js" lang="en" data-theme="light">

<head>
    @include('partials.dashboard.head')
</head>

<body class="page-home">
    @include('partials.dashboard.svg')

    <div class="sidebar-backdrop"></div>
    <div class="page-wrapper">

        <header class="header">
            <div class="header__inner">

                @include('partials.dashboard.header')

            </div>
        </header>

        <aside class="sidebar">

            @include('partials.dashboard.sidebar')

        </aside>

        <main class="page-content" style="margin-top:-40px">
            <div class="container">

                {{ $slot }}

            </div>
            <div class="text-center mt-3">
                <span class="text-center">© All Rights Reserved {{ $settings->site_name }}.</span>
            </div>
        </main>
    </div>

    @include('partials.dashboard.footer')
</body>

</html>