<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Models\User;
use App\Http\Controllers\Controller;
use App\Models\TransactionLog;

class AdminHomeController extends Controller
{
    public function show(User $user) {
        $users = $user->all();
        $active_users = $user->where('is_active',true)->get();
        $inactive_users = $user->where('is_active',false)->get();
        $pending_transactions = TransactionLog::where('status', 'pending')->get();
        $latest_transactions = TransactionLog::latest()->take(5)->get();

        return view('admin.index',  compact(
                    'users', 
                    'active_users',
                    'inactive_users',
                    'pending_transactions',
                    'latest_transactions'
                ));
    }
}
