<?php

namespace App\Http\Controllers\Admin\Auth;

use Illuminate\Http\Request;
use App\Events\UserLoginHistory;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AdminLoginController extends Controller {
    public function show() {
        return view('admin.auth.login');
    }

    public function login(Request $request) {
        // auth('admin')->loginUsingId(1);
        $credentials = $request->validate([
            'username' => ['required', 'max:255',],
            'password' => ['required'],
        ]);
        if (Auth::guard('admin')->attempt($credentials)) {
            $user = Auth::guard('admin')->user();
            return redirect()->intended(route('admin.dashboard'));
        }
        return back()->withErrors([
            'username' => 'The provided credentials do not match our records.',
        ])->onlyInput('username');
    }

    public function logout(Request $request) {
        Auth::guard('admin')->logout();

        $request->session()->regenerateToken();

        return redirect(route('admin.login'));
    }
}
