<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\TransactionLog;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Notifications\User\UserNotice;
use Carbon\Carbon;

class TransactionController extends Controller 
{
    
    public function displayAllTransactions() {
        $transactions = TransactionLog::latest()->paginate(10);
        return view('admin.transactions.all', compact('transactions'));
    }

    public function displayTransactionDetail(TransactionLog $transaction) {
        request()->session()->put('details', $transaction);

        return view('admin.transactions.single', [
            'transaction' => $transaction,
            'title' => 'Edit Transaction',
        ]);
    }

    public function editTransaction(TransactionLog $transaction) {
        request()->validate([
            'transaction_date' => 'required'
        ]);
        $transaction->update([
            'date' => request('transaction_date'),
        ]);

        return response()->json(['success' => 'Transaction updated successfully']);
    }

    public function changeStatus(TransactionLog $transaction, Request $request) {
        $data = $request->validate([
            'status' => 'required|string',
            'reject_reason' => 'nullable|string'
        ]);

        $transaction->update($data);

        $user = User::find($transaction->user->id);

        $messages = [
            "Your transaction $transaction->txn_id has been updated. The transaction status has been set to $request->status",
        ];

        if($request->status == 'rejected') {
            $messages[] = [
                'Your transaction has been rejected for the following reason:',
                $request->reject_reason,
            ];
        }
        $site_email = settings()->site_email;

        $messages[] = ["If you have any questions, please do not hesitate to contact us at $site_email"];
        $action = [
            'text' => 'View Transaction',
            'url' => route('transfer.single', $transaction->txn_id)
        ];

        $user->notify(new UserNotice(subject: "Transaction $request->status", messages: $messages, action: $action));

        return back()->with('success', $this->message('Transaction status updated.'));
    }

    public function generateReceipt() {
        return view('includes.general.transactions-single');
    }
}
