<?php

namespace App\Http\Controllers\Dashboard;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\User;
use App\Notifications\User\UserNotice;

class BankCardController extends Controller 
{

    public function index() {
        return view('dashboard.card.index');
    }

    public function show() {
        $user = User::find(auth()->id());
        return view('dashboard.card.single', [
            'user' => $user,
            'card' => $user->card,
        ]);
    }

    public function save(Request $request) {
        $user = User::find(auth()->id());
        if($user->card) {
            return back()->with('info', $this->message('You have submitted a card request already.', 'We will get back to you shortly.'));
        }
        $data = $request->validate([
            'card_type' => 'required|string',
            'card_option' => 'required|string',
            'comment' => 'required|string',
        ]);
        
        $user->card()->create([
            'type' => $request->card_type,
            'holder_name' => $user->name,
            'status' => 'pending',
            'function' => $request->card_option,
            'request' => $data['comment']
        ]);

        $messages = [
            'We have received your card request successfully.',
            'We will get back to you shortly.',
        ];
        $user->notify(new UserNotice(subject: 'Card Request', messages: $messages));

        $admins = Admin::all();
        
        $messages = [
            "$user->name requested for a card below are the details:",
            "
            1. Card Type: {$user->card->type} \n
            2. Card Function: {$user->card->function} \n
            3. Comment: {$user->card->request->comment} \n
            "
        ];

        $action = [
            'text' => 'View Card',
            'url' => route('admin.all_card_requests'),
        ];
        foreach($admins as $admin) {
            $admin->notify(new UserNotice(subject: 'New Card Request', messages: $messages, action: $action));
        }

        return back()->with('success', $this->message('Card Request Successful.', 'We will get back to you shortly.'));
    }
}
