<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\DepositMethod;
use App\Models\User;
use App\Notifications\User\UserNotice;
use Illuminate\Http\Request;

class DepositController extends Controller {
    public function online() {
        return view('dashboard.deposit.online', [
            'methods' => DepositMethod::active()->where('type', 'crypto')->get(),
            'user' => auth()->user()
        ]);
    }

    public function saveOnlineDeposit(Request $request) {
        $request->validate([
            'method_id' => 'required|numeric',
            'amount' => 'required|numeric',
            'photo_proof' => 'required|image|max:3072',
            'comment' => 'required|max:255',
        ], [], [
            'method_id' => 'crypto type'
        ]);

        $user = User::find(auth()->id());

        $photo_proof = '/uploads/' . $request->file('photo_proof')->store('/photo-proof', 'storage');

        $user->deposits()->create([
            'deposit_method_id' => $request->method_id,
            'amount' => $request->amount,
            'currency' => $user->details->currency,
            'photo_proof' => $photo_proof,
            'comment' => $request->comment,
        ]);
        
        $amount = $user->details->currency.number_format($request->amount, 2);
        $message = "Your deposit request of {$amount} has been received. We will notify you once it has been processed.";
        $user->notify(new UserNotice(subject: 'New Deposit Request', message: $message));

        return back()->with('success', 'Deposit request created successfully. We will get back to you soon.');
    }

    public function bank() {
        return back()->with('info', $this->message('Please, contact customer care for help.'));
        // return view('dashboard.deposit.bank', [
        //     'method' => DepositMethod::active()->where('type', 'bank')->first(),
        //     'user' => auth()->user()
        // ]);
    }

    public function saveBankDeposit(Request $request) {
        $user = User::find(auth()->id());

        $request->validate([
            'amount' => 'required|numeric',
            'comment' => 'required|max:255',
        ]);

        $user->deposits()->create([
            'deposit_method_id' => $request->method_id,
            'amount' => $request->amount,
            'currency' => $user->details->currency,
            'comment' => $request->comment,
        ]);

        $amount = $user->details->currency.number_format($request->amount, 2);
        $message = "Your deposit request of {$amount} has been received. We will notify you once it has been processed.";
        $user->notify(new UserNotice(subject: 'New Deposit Request', message: $message));

        return back()->with('success', 'Deposit request created successfully. We will get back to you soon.');
    }
}
