<?php

namespace App\Http\Livewire\Forms\Register;

use App\Utils\Gender;
use Illuminate\Validation\Rules\Enum;

class StepOneForm
{
    public static function rules() {
        return [
            'gender' => ['required', new Enum(Gender::class)],
            'date_of_birth' => ['required', 'date', 'before_or_equal:' . now()->subYears(18)->format('Y-m-d')],
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'occupation' => 'required|max:255',
            'country' => 'required|max:255',
            'address' => 'required|max:255',
            'marital_status' => 'required|max:255',
            'account_type' => 'required|max:255',
            'currency' => 'required|max:255',
        ];
    }
}
