<?php

namespace App\Http\Livewire\Utils;

use App\Models\TransactionLog;
use Livewire\Component;

class TransactionTime extends Component {
    public $transaction;
    public $transaction_date;
    protected $listeners = ['getLatestDate'];

    public function render() {
        return view('livewire.utils.transaction-time');
    }

    public function getLatestDate() {
        $currentTransaction = TransactionLog::find($this->transaction);
        $this->transaction_date = $currentTransaction->date;
    }
}
