<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DepositMethod extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'is_active' => 'boolean',
        'details' => 'object',
    ];

    public static function active() {
        return static::where('is_active', true);
    }

    protected function status(): Attribute {
        return Attribute::make(get: fn() => $this->is_active ? 'active': 'inactive');
    }
}
