<?php

namespace App\Notifications\User;

use App\Models\TransactionLog;
use App\Models\User;
use App\Models\Setting;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TransferCompleted extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(public TransactionLog $transaction){}

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $user
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail(User $user)
    {
        
        $settings = Setting::find(1);
        $alert_type = ucfirst($this->transaction->alert_type->value);
        return (new MailMessage)
                ->subject("{$settings->site_name} {$alert_type} Alert")
                ->markdown('emails.transfer-completed', [
                    'transaction' => $this->transaction,
                    'user' => $user
                ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toDatabase($notifiable)
    {
        return [
            'title' => "{$this->transaction->type} Transfer",
            'message' => "A {$this->transaction->type} transaction of  {$this->transaction->total_amount} occurred in your account at {$this->transaction->date}",
        ];
    }
}
