<?php

namespace App\Utils\Transfer;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

trait ValidatesTransfer {
    public User $user;
    public Request $request;

    public function initialize($request, $user) {
        $this->request = $request;
        $this->user = $user;
    }

    public function pinIsIncorrect() {
        if ($this->request->pin != $this->user->pin) {
            return true;
        }
    }

    public function balanceIsInsufficient() {
        if ($this->user->details->account_balance < $this->request->amount) {
            return true;
        }
    }

    public function transferIsDisabled() {
        if (!$this->user->details->permissions->allow_transfer) {
            return true;
        }
    }

    public function codeIsIncorrect($code, $codeType) {
        if ($this->user->details->codes->$codeType != $code) {
            return true;
        }
    }

    public function otpIsInvalid($otp) {
        $otp_expiration = Carbon::parse($this->user->otp->expires_at);
        if ($otp_expiration->isPast() || $this->user->otp->code != $otp) {
            return true;
        }
    }

    public function accountCurrencyIsDifferent() {
        $account_number = $this->request->beneficiary_account_number;
        $receiving_user = User::with('details')->firstWhere('account_number', $account_number);

        if ($receiving_user) {
            if($receiving_user->details->currency != $this->user->details->currency) {
                return true;
            }
        }
    }
}
