<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            //Database Config
            $table->id();
            $table->string('site_name')->nullable();
            $table->string('site_logo')->default('/massets/img/logo.png');
            $table->string('site_url')->nullable();
            $table->string('site_favicon')->default('/massets/img/logo.png');
            $table->string('site_email')->nullable();
            $table->string('live_support')->nullable();
            $table->string('charges')->nullable();
            //Email Config
            $table->string('mail_driver')->nullable();
            $table->string('mail_host')->nullable();
            $table->string('mail_port')->nullable();
            $table->string('mail_from')->nullable();
            $table->string('mail_encryption')->nullable();
            $table->string('mail_username')->nullable();
            $table->string('mail_password')->nullable();
            $table->string('preferences')->nullable();
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
};
