<x-mail::message>
# Dear {{ $user->name }},

A transaction with transaction ID {{ $transaction->txn_id }} has occurred in  your account on {{ $transaction->date->format('jS F, Y h:i A') }}.

Below are the details of the transaction:

<x-mail::table>
| Information       | Details                              |
| ----------------- |:------------------------------------:|
| Alert             | {{ ucfirst($transaction->alert_type->value) }} |
| Transaction Type  | {{ ucfirst($transaction->transaction_type->value) }} Transfer |
| Date              | {{ $transaction->date->format('jS F, Y h:i A') }} |
| Note              | {{ $transaction->narration }} |
@if($transaction->details)
@if($transaction->alert_type->isDebit())
| Beneficiary Name             | {{ $transaction->details->beneficiary_name }} |
| Beneficiary Account Number             | {{ $transaction->details->beneficiary_account_number }} |
| Receiving Bank            | {{ $transaction->details->receiving_bank }} |
@else
| Sender Name             | {{ $transaction->details->sender_name }} |
| Sender Account Number             | {{ $transaction->details->sender_account_number }} |
@endif
@endif
| Amount          | {{ $transaction->total_amount }} |
| Balance           | {{ $user->total_balance }} |
</x-mail::table>

<x-mail::button :url="route('transfer.single', $transaction->txn_id)">
View Transaction
</x-mail::button>

If you have any questions, please don't hesitate to contact us at {{ settings()->site_email }}.
Kind Regards,<br>
{{ config('app.name') }}
</x-mail::message>