<form method="POST" wire:submit.prevent="login">

    @if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif
    
    @if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @endif

    @if(session('message'))
    <div class="alert alert-success">
        {{ session('message') }}
    </div>
    @endif

    <div class="form-group">
        <div class="form-label-group">
            <label class="form-label" for="acct">Username</label>
        </div>
        <input type="text" autofocus="" class="@error('username') is-invalid @endif form-control form-control-lg"
            placeholder="Enter your username" wire:model="username">
            @error('username')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
    </div>


    <div class="form-group">
        <div class="form-label-group">
            <label class="form-label" for="pass">Password</label>
            <a class="link link-primary link-sm" href="{{ route('password.request') }}">Forgot Password?</a>
        </div>
        <div class="form-control-wrap">
            <a href="#" class="form-icon form-icon-right passcode-switch" id="toggle-password" data-target="password">
                <em class="passcode-icon icon-show icon ni ni-eye"></em>
                <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
            </a>

            <input type="password" class="@error('password') is-invalid @endif form-control form-control-lg" id="password" placeholder="Enter your password" wire:model="password" >
            @error('password')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
    </div>

    <div class="form-check">
        <input class="form-check-input" type="checkbox" value="1" wire:model="remember">
        <label class="form-check-label">
          Remember Me
        </label>
      </div>

    <script src="1/api.js" async="" defer=""></script>

    <div class="form-group">
        <button class="btn btn-lg btn-primary btn-block" name="login" type="submit" wire:loading.remove wire:target="login">Sign
            in</button>
        <button class="btn btn-lg btn-primary btn-block" disabled="" wire:loading wire:target="login">
            <div class="spinner-border spinner-border-sm" role="status">
                <span class="sr-only">Loading...</span>
            </div>
            Authenticating Account
        </button>
    </div>
</form>
@if(session('inactive_user'))
<script>
Notiflix.Report.failure(
    'Account Disabled',
    @js(session('inactive_user')),
    'Close'
);
</script>
@endif
@if(session('success'))
<script>
Notify.success(@js(session('success')))
</script>
@endif

@if(session('error'))
<script>
Notify.failure(@js(session('error')))
</script>
@endif

@if(session('info'))
<script>
Notify.info(@js(session('info')))
</script>
@endif