<fieldset @class(['wizard-fieldset', 'show'=> $step == 1])>
    <h5>Personal Info</h5>

    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <x-widgets.register-input name="first_name" label="First Name" />
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <x-widgets.register-input name="last_name" label="Last Name" />
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <x-widgets.register-input name="occupation" label="Occupation" />
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <select class="form-control" placeholder="country" wire:model.defer="country">
                    <option value="">Select a Country</option>
                    @include('partials.register.countries')
                </select>
                @error('country')
                <div class="wizard-form-error d-block text-danger"> <small> {{ $message }} </small></div>
                @endif
            </div>

        </div>
    </div>
    <div class="form-group">
        Gender
        <div class="wizard-form-radio">
            <input type="radio" value="male" wire:model.defer="gender">
            <label>Male</label>
        </div>
        <div class="wizard-form-radio">
            <input type="radio" value="female" wire:model.defer="gender">
            <label>Female</label>
        </div>
        @error('gender')
        <div class="wizard-form-error d-block text-danger"> <small> {{ $message }} </small></div>
        @endif
    </div>

    <h5>Residential Address</h5>
    <div class="form-group">
        <x-widgets.register-input name="address" label="Street Address" wire:ignore />
    </div>
    <h5>Account Information</h5>
    <div class="row" x-data>
        <div class="col-md-6">
            <div class="form-group">
                <x-widgets.register-input name="date_of_birth" label="Date of Birth (YYYY-MM-DD)" x-mask="9999-99-99" />
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <select type="text" class="form-control wizard-required" wire:model.defer="marital_status" required>
                    <option value="">Marital Status</option>
                    <option value="single" selected="selected">Single
                    </option>
                    <option value="married">Married
                    </option>
                    <option value="divorced">Divorced
                    </option>
                    <option value="widowed">Widowed
                    </option>
                </select>
                @error('marital_status')
                <div class="wizard-form-error d-block text-danger"> <small> {{ $message }} </small></div>
                @endif
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <select type="text" class="form-control wizard-required" wire:model.defer="account_type" required>
                    <option value="">Account Type</option>
                    <option value="savings" selected="selected">Savings
                    </option>
                    <option value="current">Current
                    </option>
                    <option value="checking">Checking
                    </option>
                    <option value="fixed deposit">Fixed Deposit
                    </option>
                    <option value="non resident">Non-Resident
                    </option>
                    <option value="online banking">Online Banking
                    </option>
                    <option value="joint">Joint Account
                    </option>
                    <option value="domiciliary">Domiciliary Account
                    </option>
                </select>
                @error('account_type')
                <div class="wizard-form-error d-block text-danger"> <small> {{ $message }} </small></div>
                @endif
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <select type="text" class="form-control wizard-required" required wire:model.defer="currency">
                    <option value="">Account Currency</option>
                    <option value="$" selected="selected">Dollar </option>
                    <option value="£">Pound </option>
                    <option value="€">Euro</option>
                </select>
                @error('currency')
                <div class="wizard-form-error d-block text-danger"> <small> {{ $message }} </small></div>
                @endif
            </div>
        </div>
    </div>

    <div class="form-group clearfix">
       <x-widgets.action-button :previous="false" />
    </div>
</fieldset>