
<?php $__env->startSection('title', 'Transaction - '.$transaction->txn_id); ?>
<?php $__env->startSection('content'); ?>
<main>
    <div class="container">

        <div class="card">
            <div class="card-body">

                <h3 class="text-center">Transaction - <?php echo e($transaction->txn_id); ?> </h3>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead-dark">
                            <tr>
                                <th>Item</th>
                                <th>Detail</th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            <tr class="text-center">
                                <th colspan="2">Amount</th>
                            </tr>
                            <tr>
                                <th class="w-25">Transaction Type</th>
                                <td class="w-25"><?php echo e(ucfirst($transaction->transaction_type->value)); ?></td>
                            </tr>
                            <tr>
                                <th>Amount</th>
                                <td><?php echo e($transaction->total_amount); ?></td>
                            </tr>
                            <tr>
                                <th>Alert Type</th>
                                <td> <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'badge' , 'text-bg-success'=> $transaction->alert_type->isCredit(),
                                        'text-bg-danger' => $transaction->alert_type->isDebit(),
                                        ]) ?>"
                                        >
                                        <?php echo e($transaction->alert_type); ?>

                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <th>Description</th>
                                <td><?php echo e($transaction->description); ?></td>
                            </tr>

                            <?php if($transaction->details): ?>

                            <tr class="text-center">
                                <th colspan="2">Transaction Details</th>
                            </tr>

                            <?php $__currentLoopData = $transaction->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($detail !== 'total_amount' && $detail !== 'total_amount' && $value): ?>
                            <tr>
                                <th><?php echo e(convertText($detail)); ?></th>
                                <td><?php echo e($value); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <tr class="text-center">
                                <th colspan="2">Others</th>
                            </tr>

                            <tr>
                                <th>Note</th>
                                <td><?php echo e($transaction->narration); ?></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([ 'badge' , 
                                        'bg-success'=> $transaction->status==='successful',
                                        'bg-info' => $transaction->status=='pending',
                                        'bg-warning' => $transaction->status=='cancelled',
                                        'bg-danger' => $transaction->status=='rejected',
                                        'bg-secondary' => $transaction->status=='expired',
                                        ]) ?>">
                                        <?php echo e($transaction->status); ?>

                                    </span>
                                </td>
                            </tr>
                            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('utils.transaction-time', [
                            'transaction' => $transaction->id,
                            'transaction_date' => $transaction->date,
                            ])->html();
} elseif ($_instance->childHasBeenRendered('pnx55PC')) {
    $componentId = $_instance->getRenderedChildComponentId('pnx55PC');
    $componentTag = $_instance->getRenderedChildComponentTagName('pnx55PC');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('pnx55PC');
} else {
    $response = \Livewire\Livewire::mount('utils.transaction-time', [
                            'transaction' => $transaction->id,
                            'transaction_date' => $transaction->date,
                            ]);
    $html = $response->html();
    $_instance->logRenderedChild('pnx55PC', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                        </tbody>
                    </table>

                    <table class="table">
                        <tr>
                            <td class="text-center fw-bold">Edit Transaction Date<br>
                                <i style="color: #00bac7" data-bs-toggle="modal" data-bs-target="#edit_transaction"
                                    id="edit" class="material-icons p-5 cursor-pointer">edit</i>
                            </td>
                            <td class="text-center fw-bold">Change Transaction Status<br>
                                <i style="color: #00bac7" data-bs-toggle="modal" data-bs-target="#edit_status"
                                    class="material-icons p-5 cursor-pointer">check_circle</i>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>
<?php echo $__env->make('includes.admin.transaction-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.admin.transaction-status-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('includes.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/learntec/universalinstant.org/resources/views/admin/transactions/single.blade.php ENDPATH**/ ?>