<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['title', 'subtitle']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['title', 'subtitle']); ?>
<?php foreach (array_filter((['title', 'subtitle']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>
<!DOCTYPE html>
<html lang="zxx" class="js">

<head>

    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="icon" href="logo.jpg">

    <title><?php echo e($title); ?> | <?php echo e(settings()->site_name); ?></title>

    <link rel="stylesheet" href="/auth/auth/assets/css/dashlite001e.css?ver=2.0.0">
    <link id="skin-default" rel="stylesheet" href="/auth/auth/assets/css/theme001e.css?ver=2.0.0">
    <link href="/auth/sweetalerts/sweetalert2.min.css" rel="stylesheet" type="text/css" />
    <link href="/auth/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />
    <link href="/auth/sweetalerts/custom-sweetalert.css" rel="stylesheet" type="text/css" />
    <script src="https://cdn.jsdelivr.net/npm/notiflix@3.2.7/dist/notiflix-aio-3.2.7.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notiflix@3.2.7/src/notiflix.min.css">
<script src="/account/user/js/notify.js"></script>
    <?php echo \Livewire\Livewire::styles(); ?>

    <style type="text/css">
        a.gflag {
            vertical-align: middle;
            font-size: 16px;
            padding: 1px 0;
            background-repeat: no-repeat;
            background-image: url(/auth/gtranslate.net/flags/16.png);
        }

        a.gflag img {
            border: 0;
        }

        a.gflag:hover {
            background-image: url(/auth/gtranslate.net/flags/16a.png);
        }

        #goog-gt-tt {
            display: none !important;
        }

        .goog-te-banner-frame {
            display: none !important;
        }

        .goog-te-menu-value:hover {
            text-decoration: none !important;
        }

        body {
            top: 0 !important;
        }

        #google_translate_element2 {
            display: none !important;
        }
    </style>
</head>

<body class="nk-body ui-rounder npc-default pg-auth no-touch nk-nio-theme"
    style="background:url(/auth/loginbg.jpeg); background-repeat:none; background-size:cover;">
    <div class="nk-app-root">

        <div class="nk-main ">

            <div class="nk-wrap nk-wrap-nosidebar">

                <div class="nk-content ">
                    <script src="/auth/account/assets/js/libs/jquery-3.1.1.min.js"></script>
                    <script src="/auth/sweetalerts/promise-polyfill.js"></script>
                    <script src="/auth/sweetalerts/sweetalert2.min.js"></script>
                    <script src="/auth/sweetalerts/custom-sweetalert.js"></script>

                    <div class="nk-block nk-block-middle nk-auth-body  wide-xs">
                        <div class="brand-logo pb-4 text-center">
                            <a href="<?php echo e(url('/')); ?>" rel="home">
                                <img class="uicore uicore-logo uicore-mobile-second"
                                    src="<?php echo e(settings()->site_logo); ?>" alt="<?php echo e(settings()->site_name); ?>"
                                    style="width:150px; margin-top:10px;  height:150px;">
                            </a>
                        </div>
                        <div class="card card-bordered" style="margin-top:10px;">
                            <div class="card-inner card-inner-lg">
                                <div class="nk-block-head">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title"><?php echo e($title); ?></h4>
                                        <div class="nk-block-des">
                                            <p><?php echo e($subtitle); ?></p>
                                        </div>
                                    </div>
                                </div>
                                <?php echo e($slot); ?>

                            </div>
                        </div>
                    </div>
                    <div class="nk-footer nk-auth-footer-full">
                        <div class="container wide-lg">
                            <div class="row g-3">
                                <div class="col-lg-6 order-lg-last">
                                    <ul class="nav nav-sm justify-content-center justify-content-lg-end">
                                        <li class="nav-item">
                                            <a class="nav-link" href="<?php echo e(url('terms')); ?>">Terms & Condition</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="<?php echo e(url('contact-us')); ?>">Help</a>
                                        </li>
                                        <li class="nav-item dropup">
                                            <div class="lang" style="margin:0 auto;">
                                                <a href="#" onclick="doGTranslate('en|ar');return false;" title="Arabic"
                                                    class="gflag nturl" style="background-position:-100px -0px;"><img
                                                        src="/auth/gtranslate.net/flags/blank.png" height="16"
                                                        width="16" alt="Arabic" /></a><a href="#"
                                                    onclick="doGTranslate('en|en');return false;" title="English"
                                                    class="gflag nturl" style="background-position:-0px -0px;"><img
                                                        src="/auth/gtranslate.net/flags/blank.png" height="16"
                                                        width="16" alt="English" /></a><a href="#"
                                                    onclick="doGTranslate('en|fr');return false;" title="French"
                                                    class="gflag nturl" style="background-position:-200px -100px;"><img
                                                        src="/auth/gtranslate.net/flags/blank.png" height="16"
                                                        width="16" alt="French" /></a><a href="#"
                                                    onclick="doGTranslate('en|de');return false;" title="German"
                                                    class="gflag nturl" style="background-position:-300px -100px;"><img
                                                        src="/auth/gtranslate.net/flags/blank.png" height="16"
                                                        width="16" alt="German" /></a><a href="#"
                                                    onclick="doGTranslate('en|it');return false;" title="Italian"
                                                    class="gflag nturl" style="background-position:-600px -100px;"><img
                                                        src="/auth/gtranslate.net/flags/blank.png" height="16"
                                                        width="16" alt="Italian" /></a><a href="#"
                                                    onclick="doGTranslate('en|es');return false;" title="Spanish"
                                                    class="gflag nturl" style="background-position:-600px -200px;"><img
                                                        src="/auth/gtranslate.net/flags/blank.png" height="16"
                                                        width="16" alt="Spanish" /></a>
                                                <div id="google_translate_element"></div>
                                                <script type="text/javascript">
                                                    function googleTranslateElementInit() { 
                                                        new google.translate.TranslateElement( 
                                                            {pageLanguage: "en"}, 
                                                            "google_translate_element" 
                                                        ); 
                                                    } 
                                                </script>
                                                <script type="text/javascript"
                                                    src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
                                                </script>
                                                <script type="text/javascript">
                                                    /* <![CDATA[ */
                                    eval(function(p,a,c,k,e,r){e=function(c){
                                        return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))
                                        };
                                        if(!''.replace(/^/,String)){while(c--)r[e(c)]=k[c]||e(c);k=[function(e){return r[e]}];e=function(){
                                            return'\\w+'};
                                            c=1};
                                            while(c--)if(k[c])p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c]);
                                            return p
                                            }('6 7(a,b){n{4(2.9){3 c=2.9("o");c.p(b,f,f);a.q(c)}g{3 c=2.r();a.s(\'t\'+b,c)}}u(e){}}6 h(a){4(a.8)a=a.8;4(a==\'\')v;3 b=a.w(\'|\')[1];3 c;3 d=2.x(\'y\');z(3 i=0;i<d.5;i++)4(d[i].A==\'B-C-D\')c=d[i];4(2.j(\'k\')==E||2.j(\'k\').l.5==0||c.5==0||c.l.5==0){F(6(){h(a)},G)}g{c.8=b;7(c,\'m\');7(c,\'m\')}}',43,43,'||document|var|if|length|function|GTranslateFireEvent|value|createEvent||||||true|else|doGTranslate||getElementById|google_translate_element2|innerHTML|change|try|HTMLEvents|initEvent|dispatchEvent|createEventObject|fireEvent|on|catch|return|split|getElementsByTagName|select|for|className|goog|te|combo|null|setTimeout|500'.split('|'),0,{}))
                                    /* ]]> */
                                                </script>
                                            </div>
                                </div>
                            </div>
                            <div class="col-lg-6 mt-2">
                                <div class="nk-block-content text-center text-lg-left">
                                    <p class="text-soft">&copy; All Rights Reserved <?php echo e(settings()->site_name); ?> Bank.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>

    </div>

    </div>


    <script src="/auth/account/bootstrap/js/popper.min.js"></script>
    <script src="/auth/account/bootstrap/js/bootstrap.min.js"></script>
    <script src="/auth/auth/assets/js/bundle001e.js?ver=2.0.0"></script>
    <script src="/auth/auth/assets/js/scripts001e.js?ver=2.0.0"></script>
    <?php echo \Livewire\Livewire::scripts(); ?>

    <script>
        var togglePassword = document.getElementById("toggle-password");
if (togglePassword) {
	togglePassword.addEventListener('click', function() {
	  var x = document.getElementById("password");
	  if (x.type === "password") {
	    x.type = "text";
	  } else {
	    x.type = "password";
	  }
	});
}
    </script>
    <?php if(session('success')): ?>
<script>
Notify.success(<?php echo \Illuminate\Support\Js::from(session('success'))->toHtml() ?>)
</script>
<?php endif; ?>

<?php if(session('error')): ?>
<script>
Notify.failure(<?php echo \Illuminate\Support\Js::from(session('error'))->toHtml() ?>)
</script>
<?php endif; ?>

<?php if(session('info')): ?>
<script>
Notify.info(<?php echo \Illuminate\Support\Js::from(session('info'))->toHtml() ?>)
</script>
<?php endif; ?>
</body>

</html><?php /**PATH /home/learntec/universalinstant.org/resources/views/components/layouts/auth.blade.php ENDPATH**/ ?>