
<?php $__env->startSection('title', 'Pending Transfers'); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Title -->
    <h1 class="h2">
        Pending Transfers
    </h1>

    <div class="row">
        <div class="col">

            <!-- Card -->
            <div class="card">
                <div class="card-body">
                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-edge table-hover table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>
                                        <a class="text-muted">
                                            Name
                                        </a>
                                    </th>


                                    <th>
                                        <a class="text-muted">
                                            Type
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Alert Type
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Date
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Status
                                        </a>
                                    </th>

                                    <th>
                                        <a class="text-muted">
                                            Amount
                                        </a>
                                    </th>
                                    <th>
                                        <a class="text-muted">
                                            View Details
                                        </a>
                                    </th>
                                </tr>
                            </thead>

                            <tbody class="list">
                                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="currency"><span><?php echo e($transaction->user->name); ?></span></td>
                                    <td><?php echo e(( ucfirst($transaction->transaction_type->value) )); ?> Transfer</td>
                                    <td>
                                        <span class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'badge',
                                            'text-bg-success' => $transaction->alert_type->isCredit(),
                                            'text-bg-danger' =>$transaction->alert_type->isDebit(),
                                        ]) ?>">
                                            <?php echo e($transaction->alert_type); ?>

                                        </span>
                                    </td>
                                    <td class="currency"><span><?php echo e($transaction->date); ?></span></td>
                                    <td>
                                        <span
                                            class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                'badge',
                                                'bg-success' => $transaction->status==='successful',
                                                'bg-warning' => $transaction->status=='cancelled',
                                                'bg-danger' => $transaction->status=='rejected',
                                                'bg-info' => $transaction->status=='pending',
                                                'bg-secondary' => $transaction->status=='expired',
                                            ]) ?>">
                                            <?php echo e($transaction->status); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($transaction->total_amount); ?></td>
                                    <td class="date"><a href="<?php echo e(route('admin.transaction-details', $transaction->txn_id)); ?>"
                                            target="_blank"><span class="badge text-bg-info ">View</span></a></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" align="center" class="fw-bold">No pending transfers.</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div> <!-- / .table-responsive -->
                </div>
            </div> <!-- / .row -->


            <div class="mt-6 p-4">
                <?php echo e($transactions->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('includes.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/learntec/universalinstant.org/resources/views/admin/international/all.blade.php ENDPATH**/ ?>